/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules.settings;

import com.ldtteam.blockout.Loader;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.View;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.client.gui.WindowSelectRes;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockSetting
implements ISetting {
    private BlockItem value;
    private BlockItem defaultValue;

    public BlockSetting(BlockItem init) {
        this.value = init;
        this.defaultValue = init;
    }

    public BlockSetting(BlockItem value, BlockItem def) {
        this.value = value;
        this.defaultValue = def;
    }

    public BlockItem getValue() {
        return this.value;
    }

    public BlockItem getDefault() {
        return this.defaultValue;
    }

    public void setValue(BlockItem value) {
        this.value = value;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setupHandler(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, Window window) {
        Loader.createFromXMLFile((String)"minecolonies:gui/layouthuts/layoutblocksetting.xml", (View)((View)pane));
        ((Text)pane.findPaneOfTypeByID("id", Text.class)).setText(key.getUniqueId().toString());
        ((Text)pane.findPaneOfTypeByID("desc", Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.setting." + key.getUniqueId().toString()));
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setHandler(button -> new WindowSelectRes(window, building, stack -> stack.func_77973_b() instanceof BlockItem, (stack, qty) -> {
            this.value = (BlockItem)stack.func_77973_b();
            settingsModuleView.trigger(key);
        }, false).open());
    }

    @Override
    public void render(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, Window window) {
        ((ItemIcon)pane.findPaneOfTypeByID("icon", ItemIcon.class)).setItem(new ItemStack((IItemProvider)this.value));
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.workerhuts.switch"));
    }

    @Override
    public void trigger() {
    }
}

